;;; -*- Mode:Common-Lisp; Package:USER; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB); Base:10 -*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (c)(1)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987, 1988, 1989,1990 Texas Instruments Incorporated. All rights reserved.*

(DEFSYSTEM 4GENERAL-INSPECTOR*
  (:NAME " 4GENERAL* 4INSPECTOR*")
  (:SHORT-NAME "G-INSPECTOR")
  (:PATHNAME-DEFAULT "3sys:*public.3general-inspector;*")
  (:PATCHABLE "3sys:patch.*public.3general-inspector;*" patch)
  (:warnings-pathname-default "3sys:*public.general-inspector.3cwarns;general-inspector.lisp*")
  (:MODULE debug-tools ("3step*" "3peek*"))
  (:MODULE inspector ("3inspect*"))
  (:MODULE flavor-inspector ("3flavor-inspector*"))
  (:MODULE trace ("3trace-window*"))      
  (:MODULE window-debugger ("3window-debug*"))
  ;1; THESE ARE NEW*
  ;1----- general inspector related -----*
  (:MODULE misc         ("3misc*")) ;1 letf et.al.*
  (:MODULE insp-inter   ("3ti-env-inspector-interface*")) ;1foo-safe stuff - TICLOS or PCL things*
  (:MODULE consistent   ("3development-tool-consistency-enhancements*"))
  (:MODULE wd-enhance   ("3window-debugger-enhancements*"))
  (:MODULE print        ("3print-and-format*"))
  (:MODULE in-enhance   ("3inspector-enhancements*"))
  (:MODULE f-insp-inter ("3ti-env-flavor-inspector-interface*")) 
  (:MODULE gen-insp     ("3general-inspector*"))
  (:MODULE gi-debug     ("3general-inspect-debugger*"))
  ;1----- grapher related -----*
  (:MODULE gr-mac       ("3macros-for-essential-graph-mixin*"))
  (:MODULE scroll       ("3basic-x-y-scrolling-window*"))
  (:MODULE gr-wind      ("3graph-window*"))
  (:MODULE func-inter   ("3functional-interface*"))
  (:MODULE gr-call-req  ("3graph-calls-req*"))
  (:MODULE gr-call      ("3graph-calls*"))

  ;1; OLD FILE DEPENDENCIES - altered slightly*
  (:COMPILE-LOAD debug-tools)
  (:COMPILE-LOAD inspector        (:FASLOAD debug-tools))
  (:COMPILE-LOAD flavor-inspector (:FASLOAD inspector))
  (:COMPILE-LOAD window-debugger  (:FASLOAD flavor-inspector))
  (:COMPILE-LOAD trace            (:FASLOAD window-debugger))

  ;1; NEW GENERAL INSPECTOR FILE DEPENDENCIES*
  (:COMPILE-LOAD misc         (:FASLOAD trace))
  (:COMPILE-LOAD insp-inter   (:FASLOAD misc))
  (:COMPILE-LOAD consistent   (:FASLOAD insp-inter))
  (:COMPILE-LOAD wd-enhance   (:FASLOAD consistent))
  (:COMPILE-LOAD print        (:FASLOAD wd-enhance))
  (:COMPILE-LOAD in-enhance   (:FASLOAD print))
  (:COMPILE-LOAD f-insp-inter (:FASLOAD in-enhance))
  (:COMPILE-LOAD gen-insp     (:FASLOAD f-insp-inter))
  (:COMPILE-LOAD gi-debug     (:FASLOAD gen-insp))

  ;1; THE GRAPHER FILE DEPENDENCIES *
  (:COMPILE-LOAD gr-mac       (:FASLOAD gi-debug))
  (:COMPILE-LOAD scroll       (:FASLOAD gr-mac))
  (:COMPILE-LOAD gr-wind      (:FASLOAD scroll))
  (:COMPILE-LOAD func-inter   (:FASLOAD gr-wind))
  (:COMPILE-LOAD gr-call-req  (:FASLOAD func-inter))
  (:COMPILE-LOAD gr-call      (:FASLOAD gr-call-req))
  )